/* 
 *  SupervisorAttachedDataTab.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class SupervisorAttachedDataTab {

    private final Tab tab;
    private final StringDataTabBase stringData;
    private final NonEditableAttachedDataKVP kvp;
    private final BinDataTabBase bin;
    private static final String BLANKDATAMESSAGE = "no DATA to display";

    public SupervisorAttachedDataTab() {
        tab = new Tab();
        tab.setText("DATA");
        tab.setClosable(false);
        tab.setDisable(true);
        TabPane tabPane = new TabPane();
        stringData = new StringDataTabBase();
        tabPane.getTabs().add(stringData.getTab());

        kvp = new NonEditableAttachedDataKVP();
        tabPane.getTabs().add(kvp.getTab());

        bin = new BinDataTabBase(BLANKDATAMESSAGE);
        tabPane.getTabs().add(bin.getTab());

        tab.setContent(tabPane);
    }

    public Tab getTab() {
        return tab;
    }

    void update(InteractionDataI data) {
        tab.setDisable(!data.canGetData());
        stringData.update(data);
        kvp.update(data);
        bin.update(data);
    }
}
